/********************************************************************************
 	

[ Uber Sounds ]

cvar:

streak_mode < flags >
"a" - messages
"b" - sounds
knife_mode < flags >
"a" - messages
"b" - sounds

hs_mode < flags >
"a" - messages
"b" - sounds

lastman_mode < flags >
"a" - messages
"b" - hp "c" - sounds

*/

// Plugin Info
new const PLUGIN[]  = "Uber Sounds"
new const VERSION[] = "1.1"
new const AUTHOR[]  = "kz4fun"


// Includes
#include <amxmodx>


//Defines
#define KNIFEMESSAGES 5
#define MESSAGESNOHP 5
#define MESSAGESHP 5
#define LEVELS 30


//Pcvars
new streak_mode, knife_mode, hs_mode, lastman_mode

new gmsgHudSync

new kills[33] = {0,...};
new deaths[33] = {0,...};
new alone_ann = 0
new levels[30] = {2, 3, 4, 5, 6, 7, 8, 9, 10, 11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};

//Streak Sounds
new stksounds[30][] = {
"misc/uber_sounds/3multikill",
"misc/uber_sounds/4megakill",
"misc/uber_sounds/5rampage",
"misc/uber_sounds/6monsterkill",
"misc/uber_sounds/7ultrakill",
"misc/uber_sounds/8holyshit",
"misc/uber_sounds/9godlike",
"misc/uber_sounds/10unstoppable",
"misc/uber_sounds/11ludacrisskill",
"misc/uber_sounds/12wickedsick",
"misc/uber_sounds/13blazeofglory",
"misc/uber_sounds/14bloodbath",
"misc/uber_sounds/15assassin",
"misc/uber_sounds/16excellent",
"misc/uber_sounds/17extermination",
"misc/uber_sounds/18hattrick",
"misc/uber_sounds/19headhunter",
"misc/uber_sounds/20impressive",
"misc/uber_sounds/21outstanding",
"misc/uber_sounds/22payback",
"misc/uber_sounds/23retribution",
"misc/uber_sounds/24vengeance",
"misc/uber_sounds/25eagleeye",
"misc/uber_sounds/26termination",
"misc/uber_sounds/27unreal",
"misc/uber_sounds/28topgun",
"misc/uber_sounds/29killingmachine",
"misc/uber_sounds/30maniac",
"misc/uber_sounds/31massacre",
"misc/uber_sounds/32warpath"};

//Exact Messages
new stkmessages[30][] = {
"%s: Multi-Kill!",
"%s: Mega-Kill!",
"%s: Rampage!",
"%s: Monster-Kill!",
"%s: Ultra-Kill!",
"%s: Holy Shit!",
"%s: Godlike!",
"%s: Unstoppable!",
"%s: Ludacriss-Kill!",
"%s: Wicked Sick!",
"%s: BlazeOfGlory!",
"%s: Blood Bath!",
"%s: Assasin!",
"%s: Excellent!",
"%s: Extermination!",
"%s: Hat Trick!",
"%s: Head Hunter!",
"%s: Impressive!",
"%s: Outstanding!",
"%s: PayBack!",
"%s: Retribution!",
"%s: Vengeance!",
"%s: Eagleeye!",
"%s: Termination!",
"%s: Unreal!",
"%s: Topgun!",
"%s: Killing Machine!",
"%s: Maniac!",
"%s: Mssacre!",
"%s: Warpath!!!"}


new knifemessages[KNIFEMESSAGES][] = 
{
	"KNIFE_MSG_1",  
	"KNIFE_MSG_2",  
	"KNIFE_MSG_3",  
	"KNIFE_MSG_4",  
	"KNIFE_MSG_5"
}

new messagesnohp[MESSAGESNOHP][] = 
{
	"NOHP_MSG_1",  
	"NOHP_MSG_2",  
	"NOHP_MSG_3",  
	"NOHP_MSG_4",  
	"NOHP_MSG_5"
}

new messageshp[MESSAGESHP][] = 
{
	"HP_MSG_1",  
	"HP_MSG_2",  
	"HP_MSG_3",  
	"HP_MSG_4",  
	"HP_MSG_5"
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("ultimate_sounds",VERSION,FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_UNLOGGED|FCVAR_SPONLY)
	register_dictionary("uber_sounds.txt")
	register_event("DeathMsg","hs","a","3=1")
	register_event("DeathMsg","knife_kill","a","4&kni")
	register_event("ResetHUD", "reset_hud", "b");
	register_event("DeathMsg", "death_event", "a", "1>0");
	register_event("DeathMsg","death_msg","a")
	register_event("SendAudio","roundend_msg","a","2=%!MRAD_terwin","2=%!MRAD_ctwin","2=%!MRAD_rounddraw")
	register_event("TextMsg","roundend_msg","a","2&#Game_C","2&#Game_w")

	lastman_mode = register_cvar("lastman_mode","abc")
	streak_mode = register_cvar("streak_mode","ab")
	knife_mode = register_cvar("knife_mode","ab")
	hs_mode = register_cvar("hs_mode","ab")

	gmsgHudSync = CreateHudSyncObj()

	return PLUGIN_CONTINUE
}


get_streak()
{
	new streak[3]
	get_pcvar_string(streak_mode,streak,2)
	return read_flags(streak)
}

public death_event(id)
{
	new streak = get_streak()

	if ((streak&1) || (streak&2))
	{
    		new killer = read_data(1);
    		new victim = read_data(2);

    		kills[killer] += 1;
    		kills[victim] = 0;
    		deaths[killer] = 0;
    		deaths[victim] += 1;

    		for (new i = 0; i < LEVELS; i++)
		{
        		if (kills[killer] == levels[i])
			{
         	  		 announce(killer, i);
         	  		 return PLUGIN_CONTINUE;
			}
		}
	}
	return PLUGIN_CONTINUE;
}

announce(killer, level)
{
	new streak = get_streak()

	if (streak&1)
	{
    		new name[32];

   		get_user_name(killer, name, 32);
		set_hudmessage(0, 100, 200, 0.05, 0.65, 2, 0.02, 6.0, 0.01, 0.1, 2);
		ShowSyncHudMsg(0, gmsgHudSync, stkmessages[level], name);
	}

	if (streak&2){
		for(new i=1;i<=get_maxplayers();i++) 
			if(is_user_connected(i) ==1 )
				client_cmd(i, "spk %s", stksounds[level]); 
	}
}

public reset_hud(id)
{
	new streak = get_streak()

	if (streak&1)
	{

		if (kills[id] > levels[0])

		{
		        client_print(id, print_chat,"%L", id, "KILL_STREAK", kills[id]);
		}

		else if (deaths[id] > 1)

		{
			client_print(id, print_chat,"%L", id, "DEATH_STREAK", deaths[id]);
		}
	}
}

public client_connect(id)
{
	new streak = get_streak()

	if ((streak&1) || (streak&2))
	{
		kills[id] = 0;
		deaths[id] = 0;
	}
}

public knife_kill()
{
	new knifemode[4] 
	get_pcvar_string(knife_mode,knifemode,4) 
	new knifemode_bit = read_flags(knifemode)

	if (knifemode_bit & 1)
	{
		new killer_id = read_data(1)
		new victim_id = read_data(2)
		new killer_name[33], victim_name[33]

		get_user_name(killer_id,killer_name,33)
		get_user_name(victim_id,victim_name,33)


		set_hudmessage(200, 100, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, 1)
		ShowSyncHudMsg(0, gmsgHudSync, "%L", LANG_PLAYER, knifemessages[ random_num(0,KNIFEMESSAGES-1) ],killer_name,victim_name)
	}

	if (knifemode_bit & 2)
	{
		for(new i=1;i<=get_maxplayers();i++) 
			if(is_user_connected(i)==1 )
				client_cmd(i,"spk misc/uber_sounds/humiliation")
   	}
}


public roundend_msg(id)

	alone_ann = 0

public death_msg(id)
{

	new lmmode[8] 
	get_pcvar_string(lastman_mode,lmmode,8) 
	new lmmode_bit = read_flags(lmmode)

	new players_ct[32], players_t[32], ict, ite, last
	get_players(players_ct,ict,"ae","CT")   
	get_players(players_t,ite,"ae","TERRORIST")   

	if (ict==1&&ite==1)
	{
		new name1[32], name2[32]
		get_user_name(players_ct[0],name1,32)
		get_user_name(players_t[0],name2,32)
		set_hudmessage(200, 100, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, 1)

		if (lmmode_bit & 1)
		{
			if (lmmode_bit & 2)
			{
				ShowSyncHudMsg(0, gmsgHudSync, "%s (%i hp) vs. %s (%i hp)",name1,get_user_health(players_ct[0]),name2,get_user_health(players_t[0]))
			}

			else
			{
				ShowSyncHudMsg(0, gmsgHudSync, "%s vs. %s",name1,name2)
			}

			if (lmmode_bit & 4)
			{
				for(new i=1;i<=get_maxplayers();i++) 
					if( is_user_connected(i) == 1 )
						client_cmd(i,"spk misc/maytheforce")
			}
		}
	} 
	else
{   
	if (ict==1&&ite>1&&alone_ann==0&&(lmmode_bit & 4))
	{
		last=players_ct[0]
		client_cmd(last,"spk misc/uber_sounds/oneandonly")
	}

	else if (ite==1&&ict>1&&alone_ann==0&&(lmmode_bit & 4))
	{
		last=players_t[0]
		client_cmd(last,"spk misc/uber_sounds/oneandonly")
	}

	else
	{
		return PLUGIN_CONTINUE
	}
	alone_ann = last
	new name[32]   
	get_user_name(last,name,32)

	if (lmmode_bit & 1)
	{
		set_hudmessage(200, 100, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, 1)

		if (lmmode_bit & 2)
		if (lmmode_bit & 2)
		{
			ShowSyncHudMsg(0, gmsgHudSync, "%L", LANG_PLAYER, messageshp[ random_num(0,MESSAGESHP-1) ],ite ,ict ,name,get_user_health(last))
		}

		else
		{
			ShowSyncHudMsg(0, gmsgHudSync, "%L", LANG_PLAYER, messagesnohp[ random_num(0,MESSAGESNOHP-1) ],ite ,ict ,name )
		}
	}
}
	return PLUGIN_CONTINUE   
}


public hs()
{
	new hsmode[4] 
	get_pcvar_string(hs_mode,hsmode,4) 
	new hsmode_bit = read_flags(hsmode)

	if (hsmode_bit & 1)
	{
	new killer_id = read_data(1)
	new victim_id = read_data(2)
	new victim_name[33]

	get_user_name(victim_id,victim_name,33)

	set_hudmessage(200, 100, 0, -1.0, 0.30, 0, 3.0, 3.0, 0.15, 0.15, 1)
	ShowSyncHudMsg(killer_id, gmsgHudSync, "HEADSHOT",victim_name)
	}

	if (hsmode_bit & 2)
	{
		for(new i=1;i<=get_maxplayers();i++) 
			if(is_user_connected(i)==1)
				client_cmd(i,"spk misc/uber_sounds/headshot")
	}
}

public plugin_precache()
{
	precache_sound("misc/uber_sounds/3multikill.wav")
	precache_sound("misc/uber_sounds/4megakill.wav")
	precache_sound("misc/uber_sounds/5rampage.wav")
	precache_sound("misc/uber_sounds/6monsterkill.wav")
	precache_sound("misc/uber_sounds/7ultrakill.wav")
	precache_sound("misc/uber_sounds/8holyshit.wav")
	precache_sound("misc/uber_sounds/9godlike.wav")
	precache_sound("misc/maytheforce.wav")
	precache_sound("misc/uber_sounds/10unstoppable.wav")
	precache_sound("misc/uber_sounds/11ludacrisskill.wav")
	precache_sound("misc/uber_sounds/12wickedsick.wav")
	precache_sound("misc/uber_sounds/13blazeofglory.wav")
	precache_sound("misc/uber_sounds/14bloodbath.wav")
	precache_sound("misc/uber_sounds/15assassin.wav")
	precache_sound("misc/uber_sounds/16excellent.wav")
	precache_sound("misc/uber_sounds/17extermination.wav")
	precache_sound("misc/uber_sounds/18hattrick.wav")
	precache_sound("misc/uber_sounds/19headhunter.wav")
	precache_sound("misc/uber_sounds/20impressive.wav")
	precache_sound("misc/uber_sounds/21outstanding.wav")
	precache_sound("misc/uber_sounds/22payback.wav")
	precache_sound("misc/uber_sounds/23retribution.wav")
	precache_sound("misc/uber_sounds/24vengeance.wav")
	precache_sound("misc/uber_sounds/25eagleeye.wav")
	precache_sound("misc/uber_sounds/26termination.wav")
	precache_sound("misc/uber_sounds/27unreal.wav")
	precache_sound("misc/uber_sounds/28topgun.wav")
	precache_sound("misc/uber_sounds/29killingmachine.wav")
	precache_sound("misc/uber_sounds/30maniac.wav")
	precache_sound("misc/uber_sounds/31massacre.wav")
	precache_sound("misc/uber_sounds/32warpath.wav")
	precache_sound("misc/uber_sounds/headshot.wav")
	precache_sound("misc/uber_sounds/humiliation.wav")
	precache_sound("misc/uber_sounds/oneandonly.wav")

	return PLUGIN_CONTINUE 
}
